using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
	public static partial class VTA_PATIENTManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static VTA_PATIENT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 VTA_ID)
		{
			VTA_PATIENT objReturn = null;
			VTA_PATIENTDB objDB = new VTA_PATIENTDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, VTA_ID);

			return objReturn;
		}

        public static VTA_PATIENT GetPatientVTAInfoByPatientId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 Patient_ID)
        {
            VTA_PATIENT objReturn = null;
            VTA_PATIENTDB objDB = new VTA_PATIENTDB();

            objReturn = objDB.GetPatientVTAInfoByPatientId(CURRENT_USER, CURRENT_REGISTRY_ID, Patient_ID);

            return objReturn;
        }

        public static List<VTA_PATIENT> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<VTA_PATIENT> objReturn = null;
			VTA_PATIENTDB objDB = new VTA_PATIENTDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
		}

		public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VTA_PATIENT objSave)
		{
			Int32 objReturn = 0;
			VTA_PATIENTDB objDB = new VTA_PATIENTDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 VTA_ID)
		{
			Boolean objReturn = false;
			VTA_PATIENTDB objDB = new VTA_PATIENTDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, VTA_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, VTA_PATIENT objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.VTA_ID);
		}

        public static STD_REFERRALSTS GetReferralStatusByReferralID(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            return STD_REFERRALSTSManager.GetItemByReferralID(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);
        }

        public static List<STD_ICD9> SelectICD9CodesByPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID, int startRow, int maxRows, string sort)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = "CODE desc";
            }

            List<STD_ICD9> objReturn = null;
            VTA_PATIENTDB objDB = new VTA_PATIENTDB();

            objReturn = objDB.SelectICD9CodesByPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);

            if (!string.IsNullOrEmpty(sort))
            {
                objReturn = objReturn.OrderBy<STD_ICD9>(sort).ToList();
            }

            if (maxRows != -1)
            {
                objReturn = objReturn.Skip(startRow).Take(maxRows).ToList();
            }

            return objReturn;
        }

        public static int SelectICD9CodesByPatientCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            List<STD_ICD9> objReturn = null;
            VTA_PATIENTDB objDB = new VTA_PATIENTDB();

            objReturn = objDB.SelectICD9CodesByPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);

            return objReturn.Count();
        }

        public static List<VTA_PATIENT_SOAP_KEYWORD> SelectSoapNoteByPatient(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID, int startRow, int maxRows, string sort)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = "SOAP_KEYWORD asc";
            }

            List<VTA_PATIENT_SOAP_KEYWORD> objReturn = null;
            VTA_PATIENTDB objDB = new VTA_PATIENTDB();

            objReturn = objDB.SelectSoapNoteByPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);

            if (!string.IsNullOrEmpty(sort))
            {
                objReturn = objReturn.OrderBy<VTA_PATIENT_SOAP_KEYWORD>(sort).ToList();
            }

            if (maxRows != -1)
            {
                objReturn = objReturn.Skip(startRow).Take(maxRows).ToList();
            }

            return objReturn;
        }

        public static int SelectSoapNoteByPatientCount(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
        {
            List<VTA_PATIENT_SOAP_KEYWORD> objReturn = null;
            VTA_PATIENTDB objDB = new VTA_PATIENTDB();

            objReturn = objDB.SelectSoapNoteByPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);

            return objReturn.Count();
        }

        #endregion
    }
}
